/**************************************************************************/
/*                                                                        */
/* Module:             TESTPM.C                                           */
/*                                                                        */
/* Function:           Interactive Service Interface -- Test program      */
/*                                                                        */
/* Classification:     IBM Internal Use Only                              */
/*                                                                        */
/**************************************************************************/
/* Interactive Service Interface is called via main entry point INTSRV.   */
/* The first argument (if any) is passed as "CallingProgname" to INTSRV.  */
/*                                                                        */
/* *** Multi-thread version:                                              */
/* *** INTSRV is called in second thread                                  */
/**************************************************************************/

/* Include files */

#define  INCL_DOS
#define  INCL_WIN
#include <OS2.H>

#include <stdlib.h>
#include <process.h>

#include "INTSRV.H"

/**************************************************************************/
/* Define directives                                                      */
/**************************************************************************/

#define STACKSIZE      8192
#define THREAD_CLOSED  WM_USER

/**************************************************************************/
/* Function declaration and structure                                     */
/**************************************************************************/

typedef struct PARM {
    HMQ   hmq;
    char *pchArg;
} PARM, *PPARM;

VOID ThreadRoutine(PVOID);

/****** main() ************************************************************/

main(int argc, char *argv[])
{
    HAB    habPM;              /* PM anchor block                         */
    HMQ    hmqPM;              /* PM message queue                        */
    QMSG   qmsg;               /* Message queue element                   */
    PVOID  pStack;             /* Stack for thread                        */
    PARM   stuParm;            /* Structure for parameters                */

    habPM = WinInitialize(0L);         /* Initialize PM                   */
    hmqPM = WinCreateMsgQueue(habPM, 0L);
    if (!hmqPM)                        /* PM failed?                      */
        return 1;

    pStack = malloc(STACKSIZE);        /* Allocate stack for thread       */
    if (!pStack)                       /* malloc failed?                  */
        return 1;

    stuParm.hmq    = hmqPM;            /* Queue handle of main thread     */
    stuParm.pchArg = argv[1];          /* First argument (may be NULL)    */

    if (_beginthread(ThreadRoutine, pStack,
        STACKSIZE, &stuParm) != -1)
    {
        while (WinGetMsg(habPM, &qmsg, 0L, 0, 0))
        {
            if (qmsg.hwnd == 0L && qmsg.msg == THREAD_CLOSED)
                break;
            else
                WinDispatchMsg(habPM, &qmsg);
        }
    }

    free(pStack);

    WinDestroyMsgQueue(hmqPM);         /* Close PM                        */
    WinTerminate(habPM);
 
    argc = argc;                       /* Avoid compiler warning          */
    return 0;
}

/****** ThreadRoutine() ***************************************************/

VOID ThreadRoutine(PVOID pArg)
{
    PPARM pParm = (PPARM) pArg;

    INTSRV(pParm->pchArg, "INTSRV is called");

    DosEnterCritSec();
    WinPostQueueMsg(pParm->hmq, THREAD_CLOSED, NULL, NULL),
    _endthread();
}
